-- name: Warp
-- incompatible: gamemode
-- description: In-game accessible warp functions.\nType "/warp help" or "/warp help2" for a list of available commands.\n\nMade mostly by anonymous\nversion 1.00n

gGlobalSyncTable.HostOnly = false --Warp commands available to everyone by default.

local hide_attempt = false

--Not using the mod storage feature for settings until it's more reliable.

--Version check idea from first person gun mod and noclip mod.
if SM64COOPDX_VERSION ~= nil and network_is_server() then
  if not mod_file_exists("warp-extra.lua") then log_to_console("\"warp-extra.lua\" file missing") end --mod_file_exists() introduced in coopDX v.1.1
  if not mod_file_exists("warp-helpers.lua") then log_to_console("\"warp-helpers.lua\" file missing") end
end

--Taken from the "Object Spawner" mod to sanitize chat command inputs.
local function strip_colors(name) --coopDX v.1.1.1 introduced get_uncolored_string() but I'll retain strip_colors() for now for compatibility with excoop
  local string = ''
  local inSlash = false
  for i = 1, #name do
    local character = name:sub(i, i)
    if character == '\\' then
      inSlash = not inSlash
    elseif not inSlash then
      string = string .. character
    end
  end
  return string
end

--Won't improve performance but it'll be easier for some people to read through the code.
function pseudo_error_handler(messageType, message_details)
  if messageType == "HELP" then
    djui_chat_message_create("Available commands: "
      ..
      "\n - \\#ffff00\\[to]\\#ffffff\\ [LevelNum] [AreaIndex] [ActNum] [(Optional) WarpId]: Warps player to given coordinates."
      .. "\n - \\#ffff00\\[castle]\\#ffffff\\ [aLevel]: Warp to entrance of specified course (id) if applicable."
      .. "\n - \\#ffff00\\[start]\\#ffffff\\: Return to starting map."
      .. "\n - \\#ffff00\\[restart]\\#ffffff\\: Resets current level instance. Moves you to start of level."
      .. "\n - \\#ffff00\\[reset]\\#ffffff\\: Resets current level instance."
      .. " \n - \\#ffff00\\[exit]\\#ffffff\\ [ |1|2]: Exit current course.\n") --Output stops here in-game.
  elseif messageType == "HELP2" then
    djui_chat_message_create("Available commands: "
      .. "\n - \\#ffff00\\[change]\\#ffffff\\ [AreaIndex]: Warp to area in level. Saves your position."
      .. "\n - \\#ffff00\\( |c|s)[get]\\#ffffff\\ [LevelNum|CourseNum|ShortName]: Prints custom level details to console."
      .. "\n - \\#ffff00\\[nget]\\#ffffff\\ [WarpId]: Prints current area's specified warp node details to console."
      .. "\n - \\#ffff00\\[popups]\\#ffffff\\ [on|off|local]: Enable/disable pop-up messages."
      .. "\n - \\#ffff00\\[host_only]\\#ffffff\\ [on|off]: Set mod commands availability.")
  elseif messageType == "ENABLED" then
    djui_chat_message_create(message_details .. " \\#ffff00\\pop-ups \\#ffffff\\will \\#10ff10\\now show up.")
  elseif messageType == "DISABLED" then
    djui_chat_message_create(message_details .. " \\#ffff00\\pop-ups \\#ffffff\\will \\#ff0000\\no longer show up.")
  elseif messageType == "SYNTAX" then --improper command syntax
    djui_chat_message_create("Usage of command: " .. message_details)
  elseif messageType == "HOST" then   --player is not host
    djui_chat_message_create("Only the \\#ffff00\\host \\#ffffff\\can use " .. message_details)
  elseif messageType == "UNRECOGNIZED" then
    djui_chat_message_create(
      "Unrecognized command. Please use \\#ffff00\\/warp help|help2\\#ffffff\\ for a list of supported commands.")
  elseif messageType == "UNSUPPORTED" then
    djui_chat_message_create("Unsupported extra command" .. message_details .. ".") --can't concatenate nil. use "" instead.
  elseif messageType == "COOPDX" then
    djui_chat_message_create("Command only available for SM64CoopDX.")
  elseif messageType == "BCUTSCENE" then
    djui_chat_message_create("Bowser cutscenes" .. message_details)
  elseif messageType == "BCOMPAT" then
    djui_chat_message_create("Bowser-compatible level restarts" .. message_details)
  end
end

--[[ Vanilla Mario 64 level values can be found here: https://github.com/djoslin0/sm64ex-coop/blob/coop/docs/lua/constants.md#enum-LevelNum
Vanilla Mario 64 course indexes for debugging: https://github.com/djoslin0/sm64ex-coop/blob/coop/text/us/courses.h ]]
--Handles, redirects and resolves most chat command inputs for the mod. Many of the code blocks that used to be in warp_cmd() were moved to extra.lua or warp-helpers.lua in their own separate functions.
local function warp_cmd(msg)
  msg = strip_colors(msg)
  local args = {} --Chat command input logic is mostly from the "Object Spawner" mod.
  for argument in msg:gmatch("%S+") do table.insert(args, argument) end
  if #args == 0 then
    table.insert(args, "help")
  end
  if (gGlobalSyncTable.HostOnly == false) or (network_is_server()) then
    if string.upper(args[1]) == "TO" then         --Warps the player to the given coordinates. Will try to take you to the default spawn point / warp node for that area.
      warp_to(args[2], args[3], args[4], args[5])
    elseif string.upper(args[1]) == "CASTLE" then --Warp to the front of the entrance of the specified course (id) if applicable.
      if tonumber(args[2]) ~= nil then            --int aLevel
        if warp_to_castle(tonumber(args[2])) == false then
          local_popup("Warp to castle level \\#ff0000\\" .. args[2] .. "\\#ffffff\\ failed.")
        else
          warp_to_castle(tonumber(args[2]))
        end
      else
        pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp castle \\#10ff10\\aLevel")
      end
    elseif string.upper(args[1]) == "START" then --Return to the starting map.
      if warp_to_start_level() == false then
        local_popup("Start level unavailable.")
      else
        warp_to_start_level()
      end
    elseif string.upper(args[1]) == "RESTART" then      --Resets the current level instance. Moves you to the start of the level.
      level_res(string.upper(args[1]))
    elseif string.upper(args[1]) == "RESET" then        --Resets the current level instance.
      level_res(string.upper(args[1]))
    elseif string.upper(args[1]) == "CHANGE" then       --Warps you to the specified area in the level. Saves your position between areas.
      if tonumber(args[2]) ~= nil then                  --Doesn't actually check if the area change is valid for the current level.
        smlua_level_util_change_area(tonumber(args[2])) --int AreaIndex
      else
        pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp change \\#10ff10\\AreaIndex")
      end
    elseif string.upper(args[1]) == "EXIT" then      --Either makes you completely exit the current level or tries to take you to the parent level before exiting the current course.
      warp_exit(args[2])
    elseif string.upper(args[1]) == "GET" then       --Outputs custom level details to the console. Only works with custom levels (e.g. "hangout" maps). Useless for level overrides / replacements (e.g. most romhacks).
      warp_get('b', args[2])
    elseif string.upper(args[1]) == "CGET" then      --Outputs custom level details to the console. Only works with custom levels (e.g. "hangout" maps). Useless for level overrides / replacements (e.g. most romhacks).
      warp_get('c', args[2])
    elseif string.upper(args[1]) == "SGET" then      --Outputs custom level details to the console. Only works with custom levels (e.g. "hangout" maps). Useless for level overrides / replacements (e.g. most romhacks).
      warp_get('s', args[2])
    elseif string.upper(args[1]) == "NGET" then      --Outputs the current area's specified warp node details to the console.
      warp_get('n', args[2])
    elseif string.upper(args[1]) == "IGET" then      --Outputs the area, displacement and id of an "instant warp" to the console from the current area
      warp_get('i', args[2])
    elseif string.upper(args[1]) == "POPUPS" then    --Enable or disable pop-up messages.
      popup_config(args[2])
    elseif string.upper(args[1]) == "HOST_ONLY" then --Allow everyone or deny everyone but the host the ability to use warp commands.
      if network_is_server() then                    --Deliberate choice to not add toggles since this command is not insignificant.
        if string.upper(args[2]) == "ON" then
          gGlobalSyncTable.HostOnly = true
          djui_popup_create_global("Warping is now \\#ffff00\\host only.", 1)
        elseif string.upper(args[2]) == "OFF" then
          gGlobalSyncTable.HostOnly = false
          djui_popup_create_global("Warping is no longer \\#ffff00\\host only.", 1)
        else
          pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp host_only \\#00ff00\\on\\#ffffff\\|\\#ff0000\\off")
        end
      else
        pseudo_error_handler("HOST", "this command.")
      end
    elseif string.upper(args[1]) == "HELP" then --Organized by predicted use-frequency.
      pseudo_error_handler("HELP", nil)
    elseif string.upper(args[1]) == "HELP2" then
      pseudo_error_handler("HELP2", nil)
    elseif string.upper(args[1]) == "PW" then     --It's just here for completeness. Expect very little support for this option for now.
      if tonumber(args[2]) ~= nil then
        initiate_painting_warp(tonumber(args[2])) --int PaintingIndex
      else
        pseudo_error_handler("SYNTAX", "\\#ffff00\\/warp pw \\#10ff10\\PaintingIndex")
      end
    elseif string.upper(args[1]) == "SHOW" then
      pauseMenuShowLevelID = not pauseMenuShowLevelID
      local_popup("Pause menu debug hud: \\#ffff00\\" .. tostring(pauseMenuShowLevelID))
    elseif string.upper(args[1]) == "EXTRA" then --Extra actions for fun. Might cause crashes.
      warp_extra(args[2], args[3])
    else
      pseudo_error_handler("UNRECOGNIZED", nil)
    end
  else
    pseudo_error_handler("HOST", "this command.")
  end
  return true
end

if (gGlobalSyncTable.HostOnly == false) or (network_is_server()) then
  hook_chat_command('warp',
    "[to|castle|start|restart|reset|change|exit|( |c|s)get|nget|popups|host_only|help|help2]", warp_cmd)
  hook_chat_command('w',
    "[to|castle|start|restart|reset|change|exit|( |c|s)get|nget|popups|host_only|help|help2]", warp_cmd)
end
